/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.common.items;

import com.yollo.dmlreforged.DeepMobLearning;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import com.yollo.dmlreforged.core.util.DataModelLevelupHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemDataModel
extends Item {
    private String mobKey;

    public ItemDataModel(String mobKey) {
        super(new Item.Properties().m_41491_(DeepMobLearning.Deep_Mob_Learning_TAB).m_41487_(1));
        this.mobKey = mobKey;
    }

    public String getMobKey() {
        return this.mobKey;
    }

    public Component m_7626_(ItemStack p_41458_) {
        return new TranslatableComponent(super.m_7626_(p_41458_).getString()).m_130938_(t -> t.m_131140_(ChatFormatting.AQUA));
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            list.add((Component)new TranslatableComponent("dmlreforged.holdshift", new Object[]{new TextComponent("SHIFT").m_130938_(t -> t.m_131140_(ChatFormatting.WHITE).m_131155_(Boolean.valueOf(true)))}).m_130938_(t -> t.m_131140_(ChatFormatting.GRAY)));
        } else {
            list.add((Component)new TranslatableComponent("dmlreforged.data_model.tier", new Object[]{DataModelHelper.getTierName(stack, false)}));
            int tier = DataModelHelper.getTier(stack);
            if (tier != 4) {
                list.add((Component)new TranslatableComponent("dmlreforged.data_model.data.collected", new Object[]{new TextComponent(Integer.toString(DataModelHelper.getCurrentTierSimulationCountWithKills(stack))).m_130938_(t -> t.m_131140_(ChatFormatting.GRAY)), new TextComponent(Integer.toString(DataModelHelper.getTierRoof(stack))).m_130938_(t -> t.m_131140_(ChatFormatting.GRAY))}));
                list.add((Component)new TranslatableComponent("dmlreforged.data_model.data.killmultiplier", new Object[]{new TextComponent(Integer.toString(DataModelLevelupHelper.getKillMultiplier(DataModelHelper.getTier(stack)))).m_130938_(t -> t.m_131140_(ChatFormatting.GRAY))}));
            }
            list.add((Component)new TranslatableComponent("dmlreforged.data_model.rfcost", new Object[]{new TextComponent(Integer.toString(DataModelHelper.getSimulationTickCost(stack))).m_130938_(t -> t.m_131140_(ChatFormatting.GRAY))}));
            if (DataModelHelper.getMatterTypeName(stack) == "living_matter_hellish") {
                list.add((Component)new TranslatableComponent("dmlreforged.data_model.type_text", new Object[]{new TranslatableComponent("dmlreforged.living_matter.hellish").m_130938_(t -> t.m_131140_(ChatFormatting.DARK_RED))}));
            }
            if (DataModelHelper.getMatterTypeName(stack) == "living_matter_extraterrestrial") {
                list.add((Component)new TranslatableComponent("dmlreforged.data_model.type_text", new Object[]{new TranslatableComponent("dmlreforged.living_matter.extraterrestrial").m_130938_(t -> t.m_131140_(ChatFormatting.LIGHT_PURPLE))}));
            }
            if (DataModelHelper.getMatterTypeName(stack) == "living_matter_overworldian") {
                list.add((Component)new TranslatableComponent("dmlreforged.data_model.type_text", new Object[]{new TranslatableComponent("dmlreforged.living_matter.overworldian").m_130938_(t -> t.m_131140_(ChatFormatting.GREEN))}));
            }
        }
    }

    public static class Zombie
    extends ItemDataModel {
        public Zombie() {
            super("zombie");
        }
    }

    public static class WitherSkeleton
    extends ItemDataModel {
        public WitherSkeleton() {
            super("witherskeleton");
        }
    }

    public static class Wither
    extends ItemDataModel {
        public Wither() {
            super("wither");
        }
    }

    public static class Witch
    extends ItemDataModel {
        public Witch() {
            super("witch");
        }
    }

    public static class Spider
    extends ItemDataModel {
        public Spider() {
            super("spider");
        }
    }

    public static class Slime
    extends ItemDataModel {
        public Slime() {
            super("slime");
        }
    }

    public static class Skeleton
    extends ItemDataModel {
        public Skeleton() {
            super("skeleton");
        }
    }

    public static class Shulker
    extends ItemDataModel {
        public Shulker() {
            super("shulker");
        }
    }

    public static class Guardian
    extends ItemDataModel {
        public Guardian() {
            super("guardian");
        }
    }

    public static class Ghast
    extends ItemDataModel {
        public Ghast() {
            super("ghast");
        }
    }

    public static class Enderman
    extends ItemDataModel {
        public Enderman() {
            super("enderman");
        }
    }

    public static class Dragon
    extends ItemDataModel {
        public Dragon() {
            super("dragon");
        }
    }

    public static class Creeper
    extends ItemDataModel {
        public Creeper() {
            super("creeper");
        }
    }

    public static class Blaze
    extends ItemDataModel {
        public Blaze() {
            super("blaze");
        }
    }
}

